---@meta

---@class FCharacterTrajectoryData
---@field RotateTowardsMovementSpeed float
---@field MaxControllerYawRate float
---@field BendVelocityTowardsAcceleration float
---@field bUseSpeedRemappingCurve boolean
---@field SpeedRemappingCurve FRuntimeFloatCurve
---@field bUseAccelerationRemappingCurve boolean
---@field AccelerationRemappingCurve FRuntimeFloatCurve
local FCharacterTrajectoryData = {}



---@class FMotionTrajectorySettings
---@field Seconds float
local FMotionTrajectorySettings = {}



---@class FTrajectorySamplingData
---@field HistoryLengthSeconds float
---@field HistorySamplesPerSecond int32
---@field PredictionLengthSeconds float
---@field PredictionSamplesPerSecond int32
local FTrajectorySamplingData = {}



---@class UCharacterTrajectoryComponent : UActorComponent
---@field Trajectory FPoseSearchQueryTrajectory
---@field SamplingData FTrajectorySamplingData
---@field CharacterTrajectoryData FCharacterTrajectoryData
local UCharacterTrajectoryComponent = {}

---@param DeltaSeconds float
---@param OldLocation FVector
---@param OldVelocity FVector
function UCharacterTrajectoryComponent:OnMovementUpdated(DeltaSeconds, OldLocation, OldVelocity) end


